/**
  ******************************************************************************
  * @file    MDR32F9Qx_config.h
  * @author  Milandr Application Team
  * @version V2.2.0
  * @date    09/12/2024
  * @brief   Library configuration file.
  ******************************************************************************
  * <br><br>
  * THE PRESENT FIRMWARE IS FOR GUIDANCE ONLY. IT AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING MILANDR'S PRODUCTS IN ORDER TO FACILITATE
  * THE USE AND SAVE TIME. MILANDR SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES RESULTING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR A USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN THEIR PRODUCTS.
  *
  */

/**
  * @mainpage MDR1986BE4 Standard Peripherals Library.
  * MDR1986BE4 Standard Peripherals Library is a package consisting of
  * all standard peripheral device drivers for 1986BE4 microcontrollers.
  * This library is a firmware package which contains a collection of routines,
  * data structures and macros covering the features of Milandr 1986BE4
  * peripherals. It includes a description of the device drivers plus a set of
  * examples for each peripheral. The firmware library allows any device to be
  * used in the user application without the need for in-depth study of each
  * peripherals specifications. Using the Standard Peripherals Library has two
  * advantages: it saves significant time that would otherwise be spent in
  * coding, while simultaneously reducing application development and
  * integration costs.
  *
  * The MDR1986BE4 Standard Peripherals Library is compatible with Milandr
  * 1986BE4x evaluation boards.
  *
  * The MDR1986BE4 Standard Peripherals Library is full CMSIS compliant.
  */


/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MDR32F9Qx_CONFIG_H
#define __MDR32F9Qx_CONFIG_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include <stdint.h>
#include "MDR1986BE4.h"

/* MDR32Fx SPL version numbers - major, minor, patch */
#define _MDR32Fx_SPL_VERSION_MAJOR (2U) /*!< [23:16] major version */
#define _MDR32Fx_SPL_VERSION_MINOR (1U) /*!< [15:8]  minor version */
#define _MDR32Fx_SPL_VERSION_PATCH (1U) /*!< [7:0]   patch version */

/* MDR32Fx SPL version number (combined value) */
#define MDR32Fx_SPL_VERSION ((_MDR32Fx_SPL_VERSION_MAJOR << 16) | \
                             (_MDR32Fx_SPL_VERSION_MINOR << 8) |  \
                             (_MDR32Fx_SPL_VERSION_PATCH))


// <c3> SWD pins protection
// <i> Prevents RTXT and OE bits setting for SWD pins when doing GPIO read-modify-write.
// <i> Uncomment the definition below to define used SWD port.
// <i> Leave all commented/unchecked if there is no GPIO pins combined with SWD.
#define USE_SWD
// </c>

// <h> Target system parameters
// <h> RST_CLK generators frequencies
// <o> HSI clock value [Hz]
// <i> Default: 8000000 (8MHz)
#define HSI_Value       ((uint32_t)8000000)
// <o> HSE clock value [Hz]
// <i> Default: 8000000 (8MHz)
#define HSE_Value       ((uint32_t)8000000)
// <o> LSI clock value [Hz]
// <i> Default: 40000 (40kHz)
#define LSI_Value       ((uint32_t)40000)
// <o> LSE clock value [Hz]
// <i> Default: 32768 (32.768kHz)
#define LSE_Value       ((uint32_t)32768)
// </h>

// <h> RST_CLK frequencies startup timeouts settings
// <o> HSE timeout startup value
// <i> Default: 0x0600
#define HSEonTimeOut    ((uint16_t)0x0600)
// <o> LSE timeout startup value
// <i> Default: 0x0600
#define LSEonTimeOut    ((uint16_t)0x0600)
// <o> HSI timeout startup value
// <i> Default: 0x0600
#define HSIonTimeOut    ((uint16_t)0x0600)
// <o> LSI timeout startup value
// <i> Default: 0x0600
#define LSIonTimeOut    ((uint16_t)0x0600)
// <o> PLLCPU timeout startup value
// <i> Default: 0x0600
#define PLLCPUonTimeOut ((uint16_t)0x0600)
// </h>

// <o> EEPROM controller freq [MHz]
 //<i> Default: 8MHz
#define FLASH_PROG_FREQ_MHZ     (8.0)
// </h>


// <h> RTC configuration parameters
// <o> RTC calibration value
// <i> Default: 0
#define RTC_CalibratorValue       0
// <o> RTC prescaler value
// <i> Default: 32768
#define RTC_PRESCALER_VALUE       32768
// </h>


// <h> Controller blocks settings
// <h> DMA configuration parameters

// <o> Alternate Control Data Structure Usage
//   <0=> 0: DMA_ALternateDataDisabled
//   <1=> 1: DMA_ALternateDataEnabled
// <i> Default: 1 (DMA_ALternateDataEnabled)
#define DMA_AlternateData       1

#if (DMA_AlternateData != 0) && (DMA_AlternateData != 1)
#error "DMA_AlternateData  should be 0 (DMA_ALternateDataDisabled) or 1 (DMA_ALternateDataEnabled)"
#endif

#if (DMA_AlternateData == 0)
// <o.0..5> Number of DMA channels to use.
// <i> Specifies size of structure table for channels in range [0; DMA_Channels_Number-1] where 0 is channel 0.
// <i> Could be changed ONLY IF DMA_AlternateData = 0 to reduce RAM usage.
// <i> If DMA_AlternateData = 1, 32 channels are always used.
// <i> This parameter is in range [1; 32]
// <i> Default: 32
#define DMA_Channels_Number     32

#if (DMA_Channels_Number < 1) || (DMA_Channels_Number > 32)
#error "DMA_Channels_Number should be in range [1; 32]"
#endif

#endif

// </h>
// </h>


// <h> Retarget standard input/output (STDIO)
// <c1> Use retarget STDIO via UART
// <i> Default: _USE_DEBUG_UART_ commented/not defined
    //#define _USE_DEBUG_UART_
// </c>
#if defined (_USE_DEBUG_UART_)

#define DEBUG_UART                  MDR_UART1
#define DEBUG_UART_CLK_SRC          RST_CLK_PER1_C2_CLK_SRC_CPU_C1

#define DEBUG_BAUD_RATE             115200
#define DEBUG_WORD_LENGTH           UART_WordLength8b
#define DEBUG_STOP_BITS             UART_StopBits1
#define DEBUG_BAUD_PARITY           UART_Parity_No

#endif /* #if defined (_USE_DEBUG_UART_) */
// </h>


#if defined (__ICCARM__) /* IAR Compiler */
    #define __attribute__(name_section)
#if defined(USE_BUILD_FLASHLOADER)
    #define __RAMFUNC
#else
    #define __RAMFUNC __ramfunc
#endif
#endif
#if defined (__CMCARM__) /* Phyton CMC-ARM Compiler */
    #define __attribute__(name_section)
    #define IAR_SECTION(section)
    #define __RAMFUNC __ramfunc
#endif
#if defined (__ARMCC_VERSION) /* ARM Compiler */
    #define IAR_SECTION(section)
    #define __RAMFUNC __attribute__((section("EXECUTABLE_MEMORY_SECTION")))
#endif


// <h> Parameter run-time check support

// <o> Paramater checking level
//   <0=> 0: no parameter checks ("assert_param" macro is disabled)
//   <1=> 1: check enabled, source file ID and line number are available
//   <2=> 2: check enabled, source file ID, line number and checking expression (as string) are available (increased code size)
// <i> Default: 0 ("assert_param" macro is disabled)
#define USE_ASSERT_INFO    0

/**
  * @brief  The assert_param macro is used for function's parameters check.
  * @param  expr: If expr is false, it calls assert_failed user's function which 
  *         reports the name of the source file, source line number
  *         and expression text (if USE_ASSERT_INFO == 2) of the call that failed.
  *         That function should not return. If expr is true, nothing is done.
  * @retval None
  */
#if (USE_ASSERT_INFO == 0)
    #define assert_param(expr) ((void)0)
#elif (USE_ASSERT_INFO == 1)
    #define assert_param(expr) ((expr) ? (void)0 : assert_failed((uint8_t *)__FILE__, __LINE__))
    void assert_failed(uint8_t* file, uint32_t line);
#elif (USE_ASSERT_INFO == 2)
    #define assert_param(expr) ((expr) ? (void)0 : assert_failed((uint8_t *)__FILE__, __LINE__, (const uint8_t*) #expr))
    void assert_failed(uint8_t* file, uint32_t line, const uint8_t* expr);
#else
    #error "Unsupported USE_ASSERT_INFO level"
#endif /* USE_ASSERT_INFO */

// </h>

#ifdef __cplusplus
} // extern "C" block end
#endif

#endif /* __MDR32F9Qx_CONFIG_H */

/*********************** (C) COPYRIGHT 2024 Milandr ****************************
*
* END OF FILE MDR32F9Qx_config.h */

